/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing2.BoundingBoxMetric;
import com.sun.electric.tool.placement.simulatedAnnealing2.PositionIndex;
import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PlacementSimulatedAnnealing
extends PlacementFrame {
    String teamName = "Team 6";
    String studentName1 = "Sebastian";
    String studentName2 = "Jochen";
    String algorithmType = "simulated annealing";
    public PlacementFrame.PlacementParameter numThreadsParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("threads", "Number of threads:", 2);
    public PlacementFrame.PlacementParameter maxRuntimeParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("runtime", "Runtime (seconds, 0 means no time limit):", 240);
    public boolean printDebugInformation = false;
    private int iterationsPerTemperatureStep;
    private double startingTemperature = 0.0;
    private double temperature;
    private int temperatureSteps = 0;
    private int temperatureStep;
    private int perturbations_tried;
    private long stepStartTime;
    private long timestampStart = 0L;
    private double maxChipLength = 0.0;
    private double minArea = 0.0;
    private ArrayList<ProxyNode> nodesToPlace;
    private List<PlacementFrame.PlacementNetwork> allNetworks;
    private BoundingBoxMetric metric = null;
    private Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap;
    private Map<PlacementFrame.PlacementNetwork, Double> netLengths = null;
    private PositionIndex posIndex;
    private final boolean performance_log = false;
    private final String performance_log_filename = "placement.log";
    private int accepts = 0;
    private int conflicts = 0;
    double[] lengthLog;
    double[] overlapLog;
    double[] timestampLog;
    double[] temperatureLog;
    double[] areaLog;
    double[] stepsizeLog;
    double[] acceptLog;
    double[] conflictLog;
    double[] stepdurationLog;
    int stepsPerUpdate = 50;
    private final double OVERLAP_WEIGHT = 100.0;
    private final double MANHATTAN_WEIGHT = 0.1;
    private final double AREA_WEIGHT = 10000.0;

    private HashMap<PlacementFrame.PlacementNode, ProxyNode> createProxyHashmap(List<ProxyNode> nodesToPlace) {
        HashMap<PlacementFrame.PlacementNode, ProxyNode> proxyMap = new HashMap<PlacementFrame.PlacementNode, ProxyNode>();
        for (ProxyNode p : nodesToPlace) {
            proxyMap.put(p.getNode(), p);
        }
        return proxyMap;
    }

    @Override
    public String getAlgorithmName() {
        return "Simulated-Annealing-2";
    }

    private int countTemperatureSteps(double startingTemperature) {
        double temperature = startingTemperature;
        int steps = 0;
        while (temperature > 1.0) {
            ++steps;
            temperature = this.coolDown(temperature);
        }
        return steps;
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        if (nodesToPlace.size() < 2) {
            return;
        }
        this.setParamterValues(this.numThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue());
        this.initializeParameters();
        this.timestampStart = System.currentTimeMillis();
        this.allNetworks = allNetworks;
        this.metric = new BoundingBoxMetric();
        this.temperatureStep = 0;
        this.iterationsPerTemperatureStep = this.runtime > 0 ? 100 : this.getDesiredMoves(nodesToPlace);
        this.perturbations_tried = 0;
        this.accepts = 0;
        this.conflicts = 0;
        this.minArea = 0.0;
        ArrayList<PlacementFrame.PlacementNetwork> ignoredNets = new ArrayList<PlacementFrame.PlacementNetwork>();
        for (PlacementFrame.PlacementNetwork placementNetwork : allNetworks) {
            if (!((double)placementNetwork.getPortsOnNet().size() >= (double)nodesToPlace.size() * 0.4) || placementNetwork.getPortsOnNet().size() <= 100) continue;
            ignoredNets.add(placementNetwork);
        }
        this.initLayout(nodesToPlace);
        this.netLengths = new HashMap<PlacementFrame.PlacementNetwork, Double>();
        this.nodesToPlace = new ArrayList(nodesToPlace.size());
        for (PlacementFrame.PlacementNode placementNode : nodesToPlace) {
            ProxyNode proxy = new ProxyNode(placementNode, ignoredNets);
            this.nodesToPlace.add(proxy);
        }
        this.proxyMap = this.createProxyHashmap(this.nodesToPlace);
        for (ProxyNode proxyNode : this.nodesToPlace) {
            this.minArea += proxyNode.width * proxyNode.height;
        }
        this.maxChipLength = this.getMaxChipLength(nodesToPlace);
        this.posIndex = new PositionIndex(this.maxChipLength, this.nodesToPlace);
        this.temperature = this.startingTemperature = this.getStartingTemperature(nodesToPlace, this.maxChipLength, this.runtime);
        this.temperatureSteps = this.countTemperatureSteps(this.startingTemperature);
        for (ProxyNode proxyNode : this.nodesToPlace) {
            proxyNode.apply();
        }
        for (PlacementFrame.PlacementNetwork placementNetwork : allNetworks) {
            this.netLengths.put(placementNetwork, this.metric.netLength(placementNetwork, this.proxyMap));
        }
        this.stepStartTime = System.nanoTime();
        int numThreads = this.numOfThreads;
        SimulatedAnnealing[] simulatedAnnealingArray = new SimulatedAnnealing[numThreads];
        for (int n = 0; n < numThreads; ++n) {
            simulatedAnnealingArray[n] = new SimulatedAnnealing();
            simulatedAnnealingArray[n].start();
        }
        for (int i = 0; i < numThreads; ++i) {
            try {
                simulatedAnnealingArray[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.cleanup();
        for (ProxyNode p : this.nodesToPlace) {
            p.apply();
        }
    }

    private void initializeParameters() {
        this.lengthLog = new double[1000000];
        this.overlapLog = new double[1000000];
        this.timestampLog = new double[1000000];
        this.temperatureLog = new double[1000000];
        this.areaLog = new double[1000000];
        this.stepsizeLog = new double[1000000];
        this.acceptLog = new double[1000000];
        this.conflictLog = new double[1000000];
        this.stepdurationLog = new double[1000000];
    }

    private double getStartingTemperature(List<PlacementFrame.PlacementNode> nodes, double length, double runtime) {
        int i;
        double[] metrics = new double[1000];
        double sigma = 0.0;
        double average = 0.0;
        Random r = new Random();
        double width = length;
        double height = length;
        for (i = 0; i < metrics.length; ++i) {
            for (PlacementFrame.PlacementNode p : nodes) {
                p.setPlacement(r.nextDouble() * width, r.nextDouble() * height);
            }
            metrics[i] = this.metric.netLength(this.allNetworks);
        }
        for (i = 0; i < metrics.length; ++i) {
            average += metrics[i];
        }
        average /= (double)metrics.length;
        for (i = 0; i < metrics.length; ++i) {
            sigma += (metrics[i] - average) * (metrics[i] - average);
        }
        sigma = Math.sqrt(sigma / (double)metrics.length);
        double startingTemperature = sigma * (-1.0 / (2.0 * Math.log(0.3)));
        if (runtime > 0.0) {
            double msPerMove = this.guessMillisecondsPerMove();
            int desired_moves = this.getDesiredMoves(nodes);
            int possibleSteps = Math.max((int)(runtime * 1000.0 / (msPerMove * (double)desired_moves)), 5);
            int stepsUntilStop = this.countTemperatureSteps(startingTemperature);
            for (int i2 = 0; i2 < stepsUntilStop - possibleSteps; ++i2) {
                startingTemperature = this.coolDown(startingTemperature);
            }
        }
        return startingTemperature;
    }

    private int getDesiredMoves(List<PlacementFrame.PlacementNode> nodes) {
        return Math.max((int)((double)nodes.size() * Math.sqrt(nodes.size())), 8719);
    }

    private double guessMillisecondsPerMove() {
        int i;
        double time = System.currentTimeMillis();
        double sampleSize = 20000.0;
        int numThreads = this.numOfThreads;
        Thread[] gatherers = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            gatherers[i] = new SampleGatherer((int)(sampleSize / (double)numThreads));
            gatherers[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                gatherers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return ((double)System.currentTimeMillis() - time) * 2.0 / sampleSize;
    }

    private double coolDown(double temp) {
        return temp * 0.99 - 0.1;
    }

    public synchronized void update(int tries, int acceptCount, int conflictCount) {
        this.perturbations_tried += tries;
        this.accepts += acceptCount;
        this.conflicts += conflictCount;
        if (this.perturbations_tried >= this.iterationsPerTemperatureStep) {
            long stepDuration = System.nanoTime() - this.stepStartTime;
            this.stepStartTime = System.nanoTime();
            if (this.runtime > 0) {
                long elapsedTime = System.currentTimeMillis() - this.timestampStart;
                long remainingTime = (long)(this.runtime * 1000) - elapsedTime;
                long remainingSteps = this.temperatureSteps - this.temperatureStep;
                double allowedTimePerStep = 1000000.0 * ((double)remainingTime / (double)remainingSteps);
                this.iterationsPerTemperatureStep = (int)((double)this.iterationsPerTemperatureStep * (allowedTimePerStep / (double)stepDuration));
                this.iterationsPerTemperatureStep = Math.max(this.stepsPerUpdate, this.iterationsPerTemperatureStep);
            }
            ++this.temperatureStep;
            this.temperature = this.coolDown(this.temperature);
            this.perturbations_tried = 0;
            this.accepts = 0;
            this.conflicts = 0;
        }
    }

    private void initLayout(List<PlacementFrame.PlacementNode> nodesToPlace) {
        int SPACING = 20;
        int numRows = (int)Math.round(Math.sqrt(nodesToPlace.size()));
        double xPos = 0.0;
        double yPos = 0.0;
        double maxHeight = 0.0;
        for (int i = 0; i < nodesToPlace.size(); ++i) {
            PlacementFrame.PlacementNode plNode = nodesToPlace.get(i);
            plNode.setPlacement(xPos += plNode.getWidth() / 2.0, yPos + plNode.getHeight() / 2.0);
            xPos += plNode.getWidth() / 2.0 + (double)SPACING;
            maxHeight = Math.max(maxHeight, plNode.getHeight());
            if (i % numRows != numRows - 1) continue;
            yPos += maxHeight + (double)SPACING;
            maxHeight = 0.0;
            xPos = 0.0;
        }
        double x = 0.0;
        double y = 0.0;
        for (PlacementFrame.PlacementNode node : nodesToPlace) {
            x += node.getPlacementX();
            y += node.getPlacementY();
        }
        double x_m = x / (double)nodesToPlace.size();
        double y_m = y / (double)nodesToPlace.size();
        for (PlacementFrame.PlacementNode node : nodesToPlace) {
            node.setPlacement(node.getPlacementX() - x_m, node.getPlacementY() - y_m);
        }
    }

    private void cleanup() {
        Object[] nodes = new ProxyNode[this.nodesToPlace.size()];
        this.nodesToPlace.toArray(nodes);
        Arrays.sort(nodes);
        for (int i = 0; i < nodes.length; ++i) {
            List<ProxyNode> co = this.posIndex.getPossibleOverlaps((ProxyNode)nodes[i]);
            ArrayList<ProxyNode> ct = new ArrayList<ProxyNode>();
            for (ProxyNode node : co) {
                if ((node.compareTo((ProxyNode)nodes[i]) >= 0 || node == nodes[i]) && !node.finalized) continue;
                ct.add(node);
            }
            double overlap = 0.0;
            while ((overlap = this.metric.overlap((ProxyNode)nodes[i], ct)) != 0.0) {
                double d = Math.sqrt(((ProxyNode)nodes[i]).getPlacementX() * ((ProxyNode)nodes[i]).getPlacementX() + ((ProxyNode)nodes[i]).getPlacementY() * ((ProxyNode)nodes[i]).getPlacementY());
                double x = ((ProxyNode)nodes[i]).getPlacementX() / d * Math.sqrt(overlap) * 0.1;
                double y = ((ProxyNode)nodes[i]).getPlacementY() / d * Math.sqrt(overlap) * 0.1;
                this.posIndex.move((ProxyNode)nodes[i], ((ProxyNode)nodes[i]).getPlacementX() + x, ((ProxyNode)nodes[i]).getPlacementY() + y);
                List<ProxyNode> co2 = this.posIndex.getPossibleOverlaps((ProxyNode)nodes[i]);
                for (ProxyNode node : co2) {
                    if (!node.finalized || ct.contains(node)) continue;
                    ct.add(node);
                }
            }
            ((ProxyNode)nodes[i]).finalized = true;
        }
    }

    private double getMaxChipLength(List<PlacementFrame.PlacementNode> nodesToPlace) {
        double totalArea = 0.0;
        for (PlacementFrame.PlacementNode p : nodesToPlace) {
            totalArea += p.getHeight() * p.getWidth();
        }
        return Math.sqrt(totalArea) * 4.0;
    }

    private void writeLog(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            for (int i = 0; i < this.temperatureStep; ++i) {
                f.append((long)this.timestampLog[i] + "," + (int)this.lengthLog[i] + "," + (int)this.temperatureLog[i] + "," + (int)this.overlapLog[i] + "," + this.areaLog[i] + "," + this.stepsizeLog[i] + "," + this.acceptLog[i] + "," + this.conflictLog[i] + "," + this.stepdurationLog[i] + "\n");
            }
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class SimulatedAnnealing
    extends Thread {
        private static final int MUTATIONSWAP = 1;
        private static final int MUTATIONMOVE = 2;
        private static final int MUTATIONORIENTATE = 3;
        Orientation[] orientations = new Orientation[]{Orientation.IDENT, Orientation.R, Orientation.RR, Orientation.RRR, Orientation.X, Orientation.XR, Orientation.XRR, Orientation.XRRR, Orientation.Y, Orientation.YR, Orientation.YRR, Orientation.YRRR, Orientation.XY, Orientation.XYR, Orientation.XYRR, Orientation.XYRRR};
        Random rand = new Random();

        SimulatedAnnealing() {
        }

        private ProxyNode getRandomNode() {
            return PlacementSimulatedAnnealing.this.nodesToPlace.get(this.rand.nextInt(PlacementSimulatedAnnealing.this.nodesToPlace.size()));
        }

        private double metricForDummy(ProxyNode original, ProxyNode dummy, HashMap<PlacementFrame.PlacementNetwork, Double> lengths) {
            double sum = 0.0;
            for (PlacementFrame.PlacementNetwork net : dummy.getNets()) {
                double length = PlacementSimulatedAnnealing.this.metric.netLength(net, PlacementSimulatedAnnealing.this.proxyMap, new ProxyNode[]{original}, new ProxyNode[]{dummy});
                lengths.put(dummy.getOriginalNet(net), length);
                sum += length;
            }
            return sum;
        }

        private double metricForDummies(ProxyNode[] originals, ProxyNode[] dummies, HashMap<PlacementFrame.PlacementNetwork, Double> lengths) {
            double sum = 0.0;
            ArrayList<PlacementFrame.PlacementNetwork> nets = new ArrayList<PlacementFrame.PlacementNetwork>();
            for (int i = 0; i < originals.length; ++i) {
                for (PlacementFrame.PlacementNetwork net : originals[i].getNets()) {
                    if (nets.contains(net)) continue;
                    nets.add(net);
                }
            }
            for (PlacementFrame.PlacementNetwork net : nets) {
                double length = PlacementSimulatedAnnealing.this.metric.netLength(net, PlacementSimulatedAnnealing.this.proxyMap, originals, dummies);
                lengths.put(net, length);
                sum += length;
            }
            return sum;
        }

        private double overlapForDummy(ProxyNode original, ProxyNode dummy) {
            List<ProxyNode> candidates = PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(dummy);
            while (candidates.remove(original)) {
            }
            return PlacementSimulatedAnnealing.this.metric.overlap(dummy, candidates);
        }

        private double overlapForDummy(ProxyNode original1, ProxyNode original2, ProxyNode dummy1, ProxyNode dummy2) {
            double overlap = 0.0;
            List<ProxyNode> candidates1 = null;
            List<ProxyNode> candidates2 = null;
            candidates1 = PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(dummy1);
            candidates2 = PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(dummy2);
            candidates1.add(dummy2);
            while (candidates1.remove(original1)) {
            }
            while (candidates1.remove(original2)) {
            }
            overlap += PlacementSimulatedAnnealing.this.metric.overlap(dummy1, candidates1);
            candidates2.add(dummy1);
            while (candidates2.remove(original1)) {
            }
            while (candidates2.remove(original2)) {
            }
            return overlap += PlacementSimulatedAnnealing.this.metric.overlap(dummy2, candidates2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (PlacementSimulatedAnnealing.this.temperature > 1.0) {
                int acceptCount = 0;
                int conflictCount = 0;
                for (int i = 0; i < PlacementSimulatedAnnealing.this.stepsPerUpdate; ++i) {
                    ProxyNode node1 = null;
                    ProxyNode node2 = null;
                    ProxyNode dummy1 = null;
                    ProxyNode dummy2 = null;
                    double networkMetricBefore = 0.0;
                    double networkMetricAfter = 0.0;
                    double overlapMetricBefore = 0.0;
                    double overlapMetricAfter = 0.0;
                    double areaMetricBefore = 0.0;
                    double areaMetricAfter = 0.0;
                    double manhattanRadiusBefore = 0.0;
                    double manhattanRadiusAfter = 0.0;
                    HashMap<PlacementFrame.PlacementNetwork, Double> newNetLengths = new HashMap<PlacementFrame.PlacementNetwork, Double>();
                    int mutationType = this.randomPerturbationType();
                    PositionIndex.AreaSnapshot area = PlacementSimulatedAnnealing.this.posIndex.area;
                    areaMetricBefore = area.getArea();
                    switch (mutationType) {
                        case 1: {
                            node1 = this.getRandomNode();
                            while ((node2 = this.getRandomNode()) == node1) {
                            }
                            networkMetricBefore = this.metricForNodes(node1, node2);
                            overlapMetricBefore = PlacementSimulatedAnnealing.this.metric.overlap(node1, PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(node1)) + PlacementSimulatedAnnealing.this.metric.overlap(node2, PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(node2));
                            dummy1 = node1.clone();
                            dummy2 = node2.clone();
                            dummy1.setPlacement(node2.getPlacementX(), node2.getPlacementY());
                            dummy2.setPlacement(node1.getPlacementX(), node1.getPlacementY());
                            networkMetricAfter = this.metricForDummies(new ProxyNode[]{node1, node2}, new ProxyNode[]{dummy1, dummy2}, newNetLengths);
                            overlapMetricAfter = this.overlapForDummy(node1, node2, dummy1, dummy2);
                            areaMetricAfter = area.areaForDummy(node1, node2, dummy1, dummy2);
                            break;
                        }
                        case 2: {
                            node1 = this.getRandomNode();
                            networkMetricBefore = this.metricForNode(node1);
                            overlapMetricBefore = PlacementSimulatedAnnealing.this.metric.overlap(node1, PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(node1));
                            manhattanRadiusBefore = Math.max(Math.abs(node1.getPlacementX()), Math.abs(node1.getPlacementY()));
                            Point2D position_t = this.randomMove(node1);
                            double new_x = (node1.getPlacementX() + position_t.getX() * (0.1 + 0.1 * PlacementSimulatedAnnealing.this.temperature / PlacementSimulatedAnnealing.this.startingTemperature)) % PlacementSimulatedAnnealing.this.maxChipLength;
                            double new_y = (node1.getPlacementY() + position_t.getY() * (0.1 + 0.1 * PlacementSimulatedAnnealing.this.temperature / PlacementSimulatedAnnealing.this.startingTemperature)) % PlacementSimulatedAnnealing.this.maxChipLength;
                            dummy1 = node1.clone();
                            dummy1.setPlacement(new_x, new_y);
                            networkMetricAfter = this.metricForDummy(node1, dummy1, newNetLengths);
                            overlapMetricAfter = this.overlapForDummy(node1, dummy1);
                            areaMetricAfter = area.areaForDummy(node1, dummy1);
                            manhattanRadiusAfter = Math.max(Math.abs(dummy1.getPlacementX()), Math.abs(dummy1.getPlacementY()));
                            break;
                        }
                        case 3: {
                            node1 = this.getRandomNode();
                            networkMetricBefore = this.metricForNode(node1);
                            overlapMetricBefore = PlacementSimulatedAnnealing.this.metric.overlap(node1, PlacementSimulatedAnnealing.this.posIndex.getPossibleOverlaps(node1));
                            dummy1 = node1.clone();
                            dummy1.setPlacementOrientation(this.orientations[this.rand.nextInt(this.orientations.length)], true);
                            networkMetricAfter = this.metricForDummy(node1, dummy1, newNetLengths);
                            overlapMetricAfter = this.overlapForDummy(node1, dummy1);
                            areaMetricAfter = area.areaForDummy(node1, dummy1);
                        }
                    }
                    double networkGain = networkMetricBefore - networkMetricAfter;
                    double overlapGain = overlapMetricBefore - overlapMetricAfter;
                    double areaGain = (areaMetricBefore - areaMetricAfter) / PlacementSimulatedAnnealing.this.minArea;
                    double manhattanRadiusGain = manhattanRadiusBefore - manhattanRadiusAfter;
                    double gain = networkGain + overlapGain * 100.0 + areaGain * 10000.0 + manhattanRadiusGain * 0.1;
                    if (!(Math.exp(gain / PlacementSimulatedAnnealing.this.temperature) >= Math.random())) continue;
                    ++acceptCount;
                    PositionIndex positionIndex = PlacementSimulatedAnnealing.this.posIndex;
                    synchronized (positionIndex) {
                        switch (mutationType) {
                            case 2: {
                                if (this.overlapForDummy(node1, dummy1) == overlapMetricAfter && this.metricForNode(node1) == networkMetricBefore) {
                                    PlacementSimulatedAnnealing.this.posIndex.move(node1, dummy1.getPlacementX(), dummy1.getPlacementY());
                                    for (PlacementFrame.PlacementNetwork net : newNetLengths.keySet()) {
                                        PlacementSimulatedAnnealing.this.netLengths.put(net, newNetLengths.get(net));
                                    }
                                    break;
                                }
                                ++conflictCount;
                                break;
                            }
                            case 1: {
                                if (this.overlapForDummy(node1, node2, dummy1, dummy2) == overlapMetricAfter && this.metricForNodes(node1, node2) == networkMetricBefore) {
                                    PlacementSimulatedAnnealing.this.posIndex.swap(node1, node2);
                                    for (PlacementFrame.PlacementNetwork net : newNetLengths.keySet()) {
                                        PlacementSimulatedAnnealing.this.netLengths.put(net, newNetLengths.get(net));
                                    }
                                    break;
                                }
                                ++conflictCount;
                                break;
                            }
                            case 3: {
                                if (this.overlapForDummy(node1, dummy1) == overlapMetricAfter && this.metricForNode(node1) == networkMetricBefore) {
                                    PlacementSimulatedAnnealing.this.posIndex.rotate(node1, dummy1.getPlacementOrientation());
                                    for (PlacementFrame.PlacementNetwork net : newNetLengths.keySet()) {
                                        PlacementSimulatedAnnealing.this.netLengths.put(net, newNetLengths.get(net));
                                    }
                                    break;
                                }
                                ++conflictCount;
                            }
                        }
                        continue;
                    }
                }
                PlacementSimulatedAnnealing.this.update(PlacementSimulatedAnnealing.this.stepsPerUpdate, acceptCount, conflictCount);
            }
        }

        private Point2D randomMove(ProxyNode node) {
            double maxBoundingBox = 1.0;
            ArrayList<PlacementFrame.PlacementNetwork> nets = node.getNets();
            if (nets.size() > 0) {
                for (PlacementFrame.PlacementNetwork net : nets) {
                    double metric = PlacementSimulatedAnnealing.this.netLengths.get(net);
                    if (!(metric > maxBoundingBox)) continue;
                    maxBoundingBox = metric;
                }
            } else {
                maxBoundingBox = PlacementSimulatedAnnealing.this.maxChipLength;
            }
            double offsetX = Math.min(Math.max(this.rand.nextGaussian(), -1.0), 1.0) * maxBoundingBox;
            double offsetY = Math.min(Math.max(this.rand.nextGaussian(), -1.0), 1.0) * maxBoundingBox;
            return new Point2D.Double(offsetX, offsetY);
        }

        private int randomPerturbationType() {
            int r = this.rand.nextInt(100);
            if (r < 10) {
                return 1;
            }
            if (r < 90) {
                return 2;
            }
            return 3;
        }

        private double metricForNodes(ProxyNode n1, ProxyNode n2) {
            double metric = this.metricForNode(n1) + this.metricForNode(n2);
            for (PlacementFrame.PlacementNetwork p : n1.getNets()) {
                if (!n2.getNets().contains(p)) continue;
                metric -= PlacementSimulatedAnnealing.this.netLengths.get(p).doubleValue();
            }
            return metric;
        }

        private double metricForNode(ProxyNode node) {
            double metric = 0.0;
            for (PlacementFrame.PlacementNetwork net : node.getNets()) {
                Double nl = PlacementSimulatedAnnealing.this.netLengths.get(net);
                if (nl == null) continue;
                metric += nl.doubleValue();
            }
            return metric;
        }
    }

    class SampleGatherer
    extends Thread {
        int samplesCount = 0;

        public SampleGatherer(int samplesCount) {
            this.samplesCount = samplesCount;
        }

        @Override
        public void run() {
            Random r = new Random();
            for (int i = 0; i < this.samplesCount; ++i) {
                ProxyNode proxy = PlacementSimulatedAnnealing.this.nodesToPlace.get(r.nextInt(PlacementSimulatedAnnealing.this.nodesToPlace.size()));
                PlacementSimulatedAnnealing.this.metric.netLength(proxy.getNets());
            }
        }
    }
}

